#ifndef TOKENIZER_H
#define TOKENIZER_H

#include <string>
#include <vector>
using namespace std;

// default delimiter string
const string DEFAULT_DELIMITER = " \t\v\n\r\f,:!?";

class Tokenizer
{
public:

    Tokenizer();
    Tokenizer(const string& str, const string& delimiter=DEFAULT_DELIMITER);

    // set string and delimiter
    void set(const string& str, const string& delimiter=DEFAULT_DELIMITER);
    void setString(const string& str);             // set source string only
    void setDelimiter(const string& delimiter);    // set delimiter string only

    string next();                                 // return the next token, return "" if it ends

    vector<string> split();                   // return array of tokens from current cursor

protected:


private:
    void skipDelimiter();                               // ignore leading delimiters
    bool isDelimiter(char c);                           // check if the current char is delimiter

    string buffer;                                 // input string
    string token;                                  // output string
    string delimiter;                              // delimiter string
    string::const_iterator currPos;                // string iterator pointing the current position

};

#endif // TOKENIZER_H
